<?php
/*
 * ajax handler for findoil requests
 * */
class ControllerInformationFindoil extends Controller {

    private $products_table = "carpartproductnames_xadoua";

    private $restrict = false;

    public function index(){
    }

    public function ajaxCalls(){

        if(!isset($_SERVER["HTTP_X_REQUESTED_WITH"]) || $_SERVER["HTTP_X_REQUESTED_WITH"] != "XMLHttpRequest"){
            if($this->restrict){
                return false;
            }
        }
        if(!isset($_SERVER["HTTP_REFERER"]) || strpos($_SERVER["HTTP_REFERER"], HTTP_SERVER) === false){
            if($this->restrict){
                return false;
            }
        }

        if(IS_LOCAL){
            $db = new DB("mysql", DB_FINDOIL_HOST_LOCAL, DB_FINDOIL_USERNAME, DB_FINDOIL_PASSWORD, "findoil");
        }
        else{
            $db = new DB("mysql", DB_FINDOIL_HOST_REMOTE, DB_FINDOIL_USERNAME, DB_FINDOIL_PASSWORD, "findoil");
        }

        $this->db_oil = $db;

        $data = array("data"=>array(),"length"=>0);

        if(isset($_POST["action"])){
            $action = trim($_POST["action"]);

            switch($action)
            {
                case "getcars":
                    if(isset($_POST['id'])){
                        $data["data"] = $this->getCars($_POST['id']);
                    }
                break;

                case "getcarmodels":
                    if(isset($_POST['id'])){
                        $data["data"] = $this->getCarModels($_POST['id']);
                    }
                break;

                case "getcarmodeltypes":
                    if(isset($_POST['id'])){
                        $data["data"] = $this->getCarmodelTypes($_POST['id']);
                    }
                break;

                case "getrecomendations":
                    if(isset($_POST['id'])){
                        $data["data"] = $this->getRecomendations($_POST['id']);
                    }
                break;
            }
        }

        $data["length"] = count($data["data"]);

        $this->response->setOutput(json_encode($data), $this->config->get('config_compression'));
        $this->response->output();
        exit;
    }

    private function getCars($vtype_id = 0){
        $q = "select `id`, `name` from cars where `vtype_id` = '".(int)$vtype_id."' ";
        return $this->db_oil->query($q)->rows;
    }

    private function getCarModels($id = 0){
        $q = "select `id`, `name` from carsmodels where `cars_id` = '".(int)$id."' ";
        return $this->db_oil->query($q)->rows;
    }

    private function getCarmodelTypes($id = 0){
        $q = "select `id`, `name` from carsmodeltypes where `carsmodels_id` = '".(int)$id."' ";
        return $this->db_oil->query($q)->rows;
    }

    private function getRecomendations($id){
        $ret = array();
        $q = "
            select
                carparts.id,
                carpartsnames_ru.name as carpartname,
                carpartsnames_ru.name_us as carpartname_us
            from carparts
            left join carpartsnames_ru on carpartsnames_ru.id = carparts.carpartsnames_id
            where carparts.carsmodeltypes_id = '".(int)$id."'
            order by carparts.id
        ";
        $parts_tmp = $this->db_oil->query($q)->rows;

        $parts = array();
        foreach($parts_tmp as $row)
        {
            $carpart_name = trim($row["carpartname"]);
            if(!$carpart_name){
                $carpart_name = trim($row["carpartname_us"]);
            }
            $parts[$row["id"]] = $carpart_name;
        }
        $ret["parts"] = $parts;

        if(!count($parts)){
            $ret["products"] = array();
            return $ret;
        }

        $q = "
            select
                carpartproducts.carparts_id, carpartproducts.text,
                ".$this->products_table.".pid
            from carpartproducts
            left join carpartproducts2carpartproductnames on carpartproducts2carpartproductnames.carpartproducts_id = carpartproducts.id
            left join ".$this->products_table." on ".$this->products_table.".id = carpartproducts2carpartproductnames.carpartproductnames_id
            where
                carpartproducts.carparts_id in (".implode(",",array_keys($parts)).")
                and ".$this->products_table.".pid > 0
            order by  carpartproducts.carparts_id
        ";
        $products_tmp = $this->db_oil->query($q)->rows;

        $pids = array();
        $texts = array();
        $products = array();
        foreach($products_tmp as $k => $row)
        {
            if(!isset($products[$row["carparts_id"]])){
                $products[$row["carparts_id"]] = array();
            }

            foreach($products[$row["carparts_id"]] as $vtmp)
            {
                if($vtmp["pid"] == $row["pid"]){
                    continue 2;
                }
            }

            $products[$row["carparts_id"]][] = array(
                "pid"=>$row["pid"]
            );
            $pids[$row["pid"]] = $row["pid"];
            $texts[$row["carparts_id"]] = $row["text"];
        }

        if(!count($pids)){
            $ret["products"] = array();
            return $ret;
        }

        $q = "
            select
                product.product_id, product.image,
                product_description.name
            from
            product
            left join product_description on product_description.product_id = product.product_id

            where
                product.product_id in(".implode(",", $pids).") and product.status = 1
                and product_description.language_id = 1
            limit ".count($pids)."
        ";
        $db_products = $this->db->query($q)->rows;

        $this->load->model('tool/seo_url');
        $this->load->model('tool/image');

        $sort = array();
        $capacities = array();

        foreach($products as $k => $v)
        {
            $sort[] = $k;
            foreach($v as $k1 => $partproduct)
            {
                foreach($db_products as $drow)
                {
                    if($partproduct["pid"] == $drow["product_id"]){
                        $products[$k][$k1]["name"] = $drow["name"];
                        if ($drow['image']){
                            $image = $drow['image'];
                        }
                        else{
                            $image = 'no_image.jpg';
                        }
                        $text = trim($texts[$k]);

                        $capacities[$k] = "";
                        if(strpos($text,"Capacity") !== false){
                            preg_match("'<td width=\"100%\">([^<]*)</td>'si",$text,$matches);
                            if(isset($matches[1])){
                                $capacities[$k] = $matches[1];
                            }
                        }

                        $products[$k][$k1]["image"] = $this->model_tool_image->resize($image, 263, 263);
                        $products[$k][$k1]["url"] = $this->model_tool_seo_url->rewrite(HTTP_SERVER . 'index.php?route=product/product&product_id=' . $drow["product_id"]);
                        break;
                    }
                }
            }
        }

        $ret["products"] = $products;
        $ret["capacities"] = $capacities;

        $ret["sort"] = $sort;

        return $ret;
    }
}
